# Variably Pretty - WordPress Plugin

Transform WooCommerce variable product dropdowns into beautiful, interactive pill-style selectors.

## Features

- **Pill-Style Selection**: Replace boring dropdowns with modern, clickable pills
- **Smart Availability**: Automatically gray out unavailable combinations
- **Selective Enabling**: Choose which products use pill-style variations via settings
- **Fully Compatible**: Works seamlessly with WooCommerce's variation system
- **Mobile Responsive**: Looks great on all screen sizes
- **Easy Configuration**: Simple admin interface in WooCommerce settings

## Installation

1. Copy the `variably-pretty` folder to `/wp-content/plugins/`
2. Activate the plugin in WordPress Admin → Plugins
3. Configure in WooCommerce → Variably Pretty

## Configuration

### Enable for All Products
Check "Enable for All Products" to apply pill-style variations to every variable product in your store.

### Enable for Specific Products
Uncheck "Enable for All Products" and select individual products from the list.

## How It Works

### Before (Standard Dropdowns)
```
Gauge: [Select dropdown ▼]
Size:  [Select dropdown ▼]
```

### After (Pill Style)
```
Gauge
─────────────────────
(18g)  (16g)  (14g)  (12g)

Size
─────────────────────
(6mm)  (7mm)  (8mm)  (10mm)
```

### Availability Logic
When you select an option (e.g., 18g gauge), the plugin automatically:
- Keeps the selected pill highlighted
- Grays out sizes that aren't available for 18g
- Updates dynamically as you make selections

## CSS Customization

Override styles in your theme's CSS:

```css
/* Change pill colors */
.variably-pretty-pill {
    border-color: #your-color;
}

.variably-pretty-pill.selected {
    background: #your-color;
    border-color: #your-color;
}

/* Change disabled state */
.variably-pretty-pill.disabled {
    opacity: 0.5;
}
```

## Technical Details

### PHP Components
- `index.php` - Main plugin file with WooCommerce integration
- Hooks into `woocommerce_dropdown_variation_attribute_options_html`
- Admin settings page under WooCommerce menu

### JavaScript
- `assets/script.js` - Handles pill interactions and availability logic
- Integrates with WooCommerce's variation form system
- Updates based on `product_variations` data

### CSS
- `assets/style.css` - Pill styling and responsive design
- Includes animations and theme variations

## Requirements

- WordPress 5.0+
- WooCommerce 4.0+
- PHP 7.4+

## Developer Hooks

### Filters
```php
// Modify pill HTML
add_filter('variably_pretty_pill_html', function($html, $option, $attribute) {
    return $html;
}, 10, 3);
```

## Troubleshooting

### Pills not appearing?
1. Ensure WooCommerce is active
2. Check that the product is set to "Variable Product"
3. Verify the product is enabled in Variably Pretty settings
4. Clear cache if using a caching plugin

### Availability not updating?
1. Check browser console for JavaScript errors
2. Ensure variations are properly configured in WooCommerce
3. Verify stock status is set correctly

## Support

For issues or feature requests, contact the developer.

## Changelog

### Version 1.0.0
- Initial release
- Pill-style variation selectors
- Availability logic
- Admin settings page
- Mobile responsive design

## License

GPL v2 or later
